/*
 * Decompiled with CFR 0.152.
 */
package org.cesar.inmotion.sea;

import java.util.Random;
import org.cesar.inmotion.sea.Constants;
import org.cesar.inmotion.sea.GameCanvas;
import org.cesar.inmotion.sea.basic.Fish;
import org.cesar.inmotion.util.ObjectSet;

public class Attack {
    private boolean active = false;
    private byte maxitems;
    private byte space;
    private ObjectSet sharks;
    private ObjectSet fishes;
    private final byte margin = (byte)45;
    private byte fish_random_factor = (byte)3;
    private byte shark_random_factor = (byte)5;

    public Attack() {
        this.init();
    }

    public Fish getShark(byte by) {
        return (Fish)this.sharks.getByIndex(by);
    }

    public Fish getFish(byte by) {
        return (Fish)this.fishes.getByIndex(by);
    }

    public byte getSharkCount() {
        return (byte)this.sharks.size();
    }

    public void init() {
        this.active = true;
        if (this.sharks == null || this.sharks.isEmpty()) {
            this.maxitems = (byte)((GameCanvas.ScreenHeight - 17 - GameCanvas.SurfaceY) / (Constants.img_diver[0][0].getHeight() * 2));
            this.sharks = new ObjectSet(this.maxitems);
            this.fishes = new ObjectSet(this.maxitems);
            int n = 0;
            while (n < this.maxitems) {
                this.sharks.add(new Fish(Constants.img_shark, 1));
                this.fishes.add(new Fish(Constants.img_fish, 1));
                ++n;
            }
        }
        this.boot();
    }

    public void boot() {
        Random random = new Random();
        int n = 0;
        while (n < this.maxitems) {
            Fish fish = (Fish)this.sharks.getByIndex(n);
            fish.setVisible(true);
            fish.ressurect();
            fish.setXspeed(3);
            Fish fish2 = (Fish)this.fishes.getByIndex(n);
            fish2.setVisible(true);
            fish2.ressurect();
            fish2.setXspeed(2);
            byte by = (byte)(random.nextInt() % this.shark_random_factor);
            byte by2 = (byte)(random.nextInt() % this.fish_random_factor);
            if (by < 0) {
                fish.setDirection((byte)-1);
            } else if (by > 0) {
                fish.setDirection((byte)1);
            } else {
                fish.setDirection((byte)0);
            }
            if (by2 < 0) {
                fish2.setDirection((byte)-1);
            } else if (by2 > 0) {
                fish2.setDirection((byte)1);
            } else {
                fish2.setDirection((byte)0);
            }
            if (fish.getDirection() == 1) {
                fish.setX(-45 + (Math.abs(random.nextInt() % 45) - fish.getImage().getWidth()));
            } else {
                fish.setX(GameCanvas.ScreenWidth + (Math.abs(random.nextInt() % 45) - fish.getImage().getWidth()));
            }
            if (fish2.getDirection() == 1) {
                fish2.setX(-45 + (Math.abs(random.nextInt() % 45) - fish2.getImage().getWidth()));
                if (fish2.intersects(fish)) {
                    fish2.setX(fish.getX() + fish.getImage().getWidth() + fish2.getImage().getWidth());
                }
            } else {
                fish2.setX(GameCanvas.ScreenWidth + 10 + (Math.abs(random.nextInt() % 45) - fish2.getImage().getWidth()));
                if (fish2.intersects(fish)) {
                    fish2.setX(fish.getX() - fish2.getImage().getWidth());
                }
            }
            fish.setY(GameCanvas.SurfaceY + Constants.img_diver_surface[0].getHeight() + 2 * n * Constants.img_diver[0][0].getHeight());
            fish2.setY(fish.getY());
            ++n;
        }
    }

    public void update() {
        this.active = false;
        int n = 0;
        while (n < this.maxitems) {
            Fish fish = (Fish)this.sharks.getByIndex(n);
            Fish fish2 = (Fish)this.fishes.getByIndex(n);
            fish.update();
            fish2.update();
            if (fish.isVisible() || fish2.isVisible()) {
                this.active = true;
            }
            if (!fish.isDead()) {
                if (fish.intersects(fish2)) {
                    fish2.setDirection(fish.getDirection());
                    fish2.setXspeed(fish.getXspeed());
                }
            } else {
                fish2.setXspeed(2);
            }
            ++n;
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setLevel(byte by) {
        int n = 0;
        while (n < this.maxitems) {
            this.sharks.getByIndex(n).setXspeed(by);
            this.fish_random_factor = (byte)(this.fish_random_factor - 1);
            this.shark_random_factor = (byte)(this.shark_random_factor + 2);
            ++n;
        }
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public byte getMaxitems() {
        return this.maxitems;
    }
}

